# Contributing to Myth:Auth

Thanks for taking an interest in this project and wanting to help out! We're excited to hear from you. Your experiences
will help everyone else out, as we're all in different stages of our careers, and all have different programming backgrounds.

The following guidelines are here to help you figure out how you can be the most helpful.

## Types of Contributions We're Looking For

There are a number of ways that you can help contribute to Myth:Auth:

* Fix any bugs that you find
* Help ensure the codebase is well tested so we all have a secure experience.
* Fix typos and errors/ommissions in the docs.
* Write new docs or tutorials!
* Revise language to be more approachable and friendly

Interested in making a contribution? Read on!

## Ground rules & expectations

Before we get started, here are a few things we expect from you (and that you should expect from others):

* Be kind and thoughtful in your conversations around this project. We all come from different backgrounds and projects,
    which means we likely have different perspectives on "how open source is done." Try to listen to others rather than
    convince them that your way is correct.
* If you open a pull request, please ensure that your contribution passes all tests. If there are test failures, you
    will need to address them before we can merge your contribution.
* Likewise, if you open a pull request, all new code is expected to be covered by a test. If no tests are provided,
    we will not be able to merge your pull request.
* When contributing to documentation, make every effort to keep it clear, concise, and friendly. If English is not
    your native language - that's ok! Feel free to do your best and then ask for help to smooth out any rough
    edges, if needed.

## How to contribute

If you'd like to contribute, start by searching through the [issues](https://github.com/lonnieezell/myth-auth/issues)
and [pull requests](https://github.com/lonnieezell/myth-auth/pulls) to see whether someone else has raised a similar idea or question.

If you don't see your idea listed, and you think it fits into the goals of this guide, do one of the following:

* **If your contribution is minor,** such as a typo fix, open a pull request.
* **If your contribution is major,** such as a new feature, start by opening an issue first. That way, other people can
    weigh in on the discussion before you do any work.
