<?php
// Folder tempat file disimpan
$folder = "docs/";

// Periksa apakah parameter "file" ada
if (isset($_GET['file'])) {
    $fileName = basename($_GET['file']); // Hindari traversal direktori
    $filePath = $folder . $fileName;
    $fileExtension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));

    // Periksa apakah file ada
    if (file_exists($filePath)) {
        // Tentukan cara membaca file berdasarkan format
        switch ($fileExtension) {
            case "txt":
                $content = htmlspecialchars(file_get_contents($filePath));
                echo "<h1>Isi Dokumen</h1><pre>$content</pre>";
                break;

            case "pdf":
                echo "<h1>PDF Viewer</h1>";
                echo "<iframe src='https://docs.google.com/gview?url=" . urlencode("http://yourdomain.com/$filePath") . "&embedded=true' style='width:100%; height:600px;' frameborder='0'></iframe>";
                break;

            case "doc":
            case "docx":
            case "xls":
            case "xlsx":
                echo "<h1>Dokumen Office</h1>";
                echo "<iframe src='https://view.officeapps.live.com/op/view.aspx?src=" . urlencode("http://yourdomain.com/$filePath") . "' style='width:100%; height:600px;' frameborder='0'></iframe>";
                break;

            case "csv":
                echo "<h1>CSV Viewer</h1>";
                if (($handle = fopen($filePath, "r")) !== false) {
                    echo "<table border='1' style='width:100%; border-collapse:collapse;'>";
                    while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                        echo "<tr>";
                        foreach ($data as $cell) {
                            echo "<td>" . htmlspecialchars($cell) . "</td>";
                        }
                        echo "</tr>";
                    }
                    echo "</table>";
                    fclose($handle);
                } else {
                    echo "<p>Gagal membaca file CSV.</p>";
                }
                break;

            case "html":
            case "htm":
                echo "<h1>HTML Viewer</h1>";
                echo "<iframe src='$filePath' style='width:100%; height:600px;' frameborder='0'></iframe>";
                break;

            default:
                echo "<p>Format file tidak didukung.</p>";
        }
    } else {
        echo "<h1>File tidak ditemukan.</h1>";
    }
} else {
    echo "<h1>Tidak ada file yang dipilih.</h1>";
}
?>
